<?php

namespace App\Http\Controllers\Site\FeeReport;

use App\Http\Controllers\ProjectController;
use App\Models\Academic\AcademicAdmissionFeeType;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicClassGroup;
use App\Models\Academic\AcademicFeeHead;
use App\Models\Academic\AcademicFeeSubHead;
use App\Models\Academic\AcademicGeneralFeeType;
use App\Models\Academic\AcademicMonthName;
use App\Models\Academic\AcademicSection;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Examinations\Examination;
use App\Models\Site\Employee\Employee;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeeFineAllocation;
use App\Models\Site\Fee\SiteStudentFeeGenerate;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Fee\SiteStudentFeeWaiverOfferHistory;
use App\Models\Site\SiteInfo;
use App\Models\Site\SiteInfoSetting\SiteInfoSetting;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\User\GlobalUser;
use App\User;
//use User
use Auth;
use Carbon\Carbon;
use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Arr;
use PDF;
use Error;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DateTime;
use phpDocumentor\Reflection\Types\Array_;
use Psy\Test\Exception\RuntimeExceptionTest;
use Response;

class SiteFeeReportController extends ProjectController
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    private $siteStudentFeeGenerate;
    private $siteStudentFeeDemandSlipDetails;
    private $siteStudentFeeWaiverOfferHistory;

    public function __construct(SiteStudentFeeGenerate $siteStudentFeeGenerate, SiteStudentFeeDemandSlipDetails $siteStudentFeeDemandSlipDetails,
                                SiteStudentFeeWaiverOfferHistory $siteStudentFeeWaiverOfferHistory)
    {
        $this->middleware('auth');
        //$this->middleware('eduworlduserchecker');
        // $this->middleware('sitepagechecker');
        $this->siteStudentFeeGenerate = $siteStudentFeeGenerate;
        $this->siteStudentFeeDemandSlipDetails = $siteStudentFeeDemandSlipDetails;
        $this->siteStudentFeeWaiverOfferHistory = $siteStudentFeeWaiverOfferHistory;

    }

//    public function __construct()
//    {
//
//        $this->middleware('auth');
//        $this->middleware('sitepagechecker');
//
//
//
//    }


    public function index()
    {
        $viewType = 'Fee report';
        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.sites.fee.fee-report.payment-report', compact('viewType'));
    }

    public function getAcademicYearList()
    {
        $the_site_info_setting = SiteInfoSetting::first();

        if (!$the_site_info_setting) {
            return Response::json(['message' => 'No "SiteInfoSetting" Found'], 422);
        }

        $academicYear = explode(',', $the_site_info_setting->academic_year_ids ?? null);
        $academicYearList = AcademicYear::whereIn('id', $academicYear)->orderBy('id','DESC')->get();

        $dateComponents = getdate();
        $year = $dateComponents['year'];

        return [$academicYearList,$year];

    }

    public function getSingleStudentPaymentReportList(Request $request)
    {
        $academic_year_id = $request->academic_year_id;

        $request->validate([
            'user_id' => 'required',
        ]);

        if ($request->user_id) {
            $userList = Student::where('username', $request->user_id)->select('id')->first();
            if ($userList) {
                if($academic_year_id){
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('academic_year_id',$academic_year_id)
                        ->orderBy('id','desc')
                        ->first();

                }else{
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('status', 1)
                        ->first();
                }

            } else {
                throw new Error('Sorry! Student not found');
            }

//            return $studentHistoryList;
            $head_ids_list = SiteInfoSetting::first();
            $head_list = AcademicFeeHead::whereIn('id', explode(',', $head_ids_list->academic_fee_head_ids))->get();

            $demand_slip_details = $this->siteStudentFeeDemandSlipDetails->where('student_history_id', $studentHistoryList->id)->get();

//            return $demand_slip_details;

            $total_amount = 0;
            $total_generated_amount = 0;
            $total_paid_amount = 0;
            $total_due = 0;
            $total_payable_amount = 0;
            $total_fee_fine = 0;
            $total_not_paid_demand_slip_delay_fine = 0;
            $tot_waiver_amount = 0;
            $paymentHistoryArr = [];
            $voucherArr = [];
            $total_waiver_amount = 0;
//            $waiver_allocation_details_array = [];
            $waiver_allocation_details_arr = Array();
            $srl = 0;
            $waiver_srl = 0;
            if(count($demand_slip_details)>0){
                foreach ($demand_slip_details as $key => $value){

                    //================total generated amount==================
                    $total_generated_amount+=$value->fee_amount;

                    //=====================total payment======================
                    $payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $value->id)->get();
                    if(count($payment_history)>0){
                        foreach ($payment_history as $kk => $vv){
                            $total_paid_amount+=$vv->paid_amount;
                        }
                    }
                    //=====================total waiver=======================
                    $student_waiver = SiteStudentFeeWaiverOfferHistory::where('site_student_fee_demand_slip_detail_id', $value->id)
                        ->where('demand_slip_create_status', 1)
                        ->get();
                    if(count($student_waiver)>0){
                        foreach ($student_waiver as $kkk => $vvv){
                            $total_waiver_amount+=$vvv->amount;
                        }

                    }
                    //===============total demand slip delay fine==============
                    $mytime = Carbon::now();
                    $today_date =  $mytime->toDateString();

                    if($value->status == 1 && $value->payment_from_date){

                        $start_date = $value->payment_from_date;
                        $end_date = $value->payment_to_date;

                        $period = CarbonPeriod::create($start_date, $end_date);

                        $delay_fine_test = 1;
                        foreach ($period as $date) {
                            $formated_date =  $date->format('Y-m-d');
                            if($formated_date == $today_date){
                                $delay_fine_test = 0;
                            }
                        }

                        if($delay_fine_test==1){
                            $total_not_paid_demand_slip_delay_fine+=$value->delay_fine;
                        }


                    }

                    //================table data===============
                    $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);
                    $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->with('siteStudentFeeFineAllocation')->get();

                    if (count($fee_generate_details) > 0) {

                        foreach ($fee_generate_details as $k => $v) {
                            $paymentHistoryArr[$srl]['fee_item'] = AcademicFeeSubHead::where('id', $v->siteStudentFeeFineAllocation->academic_fee_sub_head_id)->first();
                            $paymentHistoryArr[$srl]['amount'] = $v->amount;
                            $total_amount+= $v->amount;
//                            $paymentHistoryArr[$key][$k]['taken_by'] = Employee::where('id', $value->created_by)->first();


                            $fee_allocation_detail = SiteStudentFeeFineAllocation::
                            with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                                ->where('id', $v->site_student_fee_fine_allocation_id)->first();


                            if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {
                                $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                                $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                                $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->examination_name;
                            }

//                            $total_generated_amount += $v->amount;
                            $srl++;

                        }

                    }

                    $waiver_generate_id_splite = explode(',', $value->site_student_fee_waiver_offer_history_ids);
                    $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

                    //==================Waiver List =========

                    if(count($waiver_generate_list)>0){
                        foreach ($waiver_generate_list as $key => $value){

                            if($value->site_student_fee_fine_allocation_id){
                                $tot_waiver_amount+=$value->amount;

                                $waiver_allocation_detail= SiteStudentFeeFineAllocation::
                                with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                                    ->where('id',$value->site_student_fee_fine_allocation_id)->first();

                                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                                    $waiver_type = AcademicAdmissionFeeType::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                                    $waiver_type = AcademicMonthName::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                                    $waiver_type = Examination::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->examination_name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                                    $waiver_type = AcademicGeneralFeeType::where('id', $value->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;
                                }

                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;
                                $waiver_allocation_details_arr[$waiver_srl]['amount']=$value->amount;


//                                $waiver_allocation_details_array[$waiver_srl]=array_merge($waiver_allocation_details_arr, $value->toArray());
                                $waiver_srl++;
                            }

                        }
                    }

                }

            }else{
                return Response::json(['message' => 'payment not generated yet!'], 411);
            }

            //=====================total fee fine======================
            $student_fee_fine = SiteStudentFeeFine::where('student_history_id', $studentHistoryList->id)->get();
            if(count($student_fee_fine)>0){
                foreach ($student_fee_fine as $kke => $vvl){
                    $total_fee_fine+=$vvl->fine_amount;
                }
            }
            //=========================total due=======================
            $total_payable_amount = $total_generated_amount + $total_fee_fine + $total_not_paid_demand_slip_delay_fine  - $total_waiver_amount;
            $total_due = $total_payable_amount - $total_paid_amount;

            $voucherArr['total_amount'] = 0;
            $voucherArr['taken_by '] = "";
            $voucherArr['total_generated_amount'] = number_format($total_generated_amount);
            $voucherArr['fee_fine'] = number_format( $total_fee_fine + $total_not_paid_demand_slip_delay_fine);
            $voucherArr['total_waiver_amount'] = number_format($total_waiver_amount);
            $voucherArr['total_payable_amount'] = number_format($total_payable_amount);
            $voucherArr['total_paid_amount'] = number_format($total_paid_amount);
            $voucherArr['total_due'] = number_format($total_due);
            $voucherArr['std_id'] = $studentHistoryList->id;
            $voucherArr['std_name'] = $studentHistoryList->student->full_name;
            $voucherArr['class_name'] = $class_name = $studentHistoryList->stClass->class_name;
            $voucherArr['group_name'] = $studentHistoryList->accGroup->group_name ?? "N/A";
            $voucherArr['section_name'] = $studentHistoryList->section->section_name ?? "N/A";

            return [$paymentHistoryArr, $voucherArr, $head_list,  $total_amount, $waiver_allocation_details_arr, $tot_waiver_amount];

        } else {
            return Response::json(['message' => 'Sorry! please search with student ID'], 411);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getSiteFeeHeadBaseTypeList(Request $request)
    {

        if ($request->checked_fee_head_id != null) {

            $feeheadlist = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();
            $headBaseValue = null;
            $headBaseTypelist = Array();
            if ($feeheadlist->head_key == 'monthly') {
                $headBaseTypelist = AcademicMonthName::orderBy('serial_no','desc')->get();
                $headBaseValue = 'monthly';

                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            } else if ($feeheadlist->head_key == 'examination') {

                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

                $selectedSiteGroupList = SiteInfoSetting::first();
                $Examinationlist = Examination::whereIn('id', explode(',', $selectedSiteGroupList->examination_ids))->get();

                $headBaseTypelist = [];
                $headBaseTypelistArr = Array();
                foreach ($Examinationlist as $key => $value) {

                    $headBaseTypelistArr['id'] = $value->id;
                    $headBaseTypelistArr['name'] = $value->examination_name;

                    $headBaseTypelist[$key] = array_merge($headBaseTypelistArr);
                }
                $headBaseValue = 'examination';

            } else if ($feeheadlist->head_key == 'admission') {
                $headBaseTypelist = AcademicAdmissionFeeType::get();
                $headBaseValue = 'admission';
                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            } else if ($feeheadlist->head_key == 'general') {

                $headBaseTypelist = AcademicGeneralFeeType::get();
                $headBaseValue = 'general';
                $fee_details = $this->getHeadBaseSingleStudentPaymentList($request, $feeheadlist);

            }
            if ($fee_details) {

                $fee_details_list = $fee_details[0];
                $fee_waiver_list = $fee_details[1];
                $total_amount = $fee_details[2];
                $total_waiver_amount = $fee_details[3];
                return response()->json([$headBaseValue, $headBaseTypelist, $fee_details_list, $fee_waiver_list, $total_amount, $total_waiver_amount], 200, [], JSON_NUMERIC_CHECK);

            } else {
                throw new Error('Sorry! Payment not completed at yet!');
            }

        }


    }


    public function getHeadBaseSingleStudentPaymentList($request, $feeheadlist)
    {

        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('student_history_id', $request->student_histories_id)->get();
        $srl = 0;
        $waiver_srl = 0;
        $tot_waiver_amount = 0;
        $total_amount = 0;
        $waiver_allocation_details_arr = Array();
        if (count($demand_slip_details) > 0) {

            $feeGenerateHistoryArr = Array();
            foreach ($demand_slip_details as $key => $value) {

                //==================Waiver Details =========

                $waiver_generate_id_splite = explode(',', $value->site_student_fee_waiver_offer_history_ids);
                $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)->get();

                if(count($waiver_generate_list)>0){
                    foreach ($waiver_generate_list as $kk => $vvl){

                        if($vvl->site_student_fee_fine_allocation_id){


                            $waiver_allocation_detail= SiteStudentFeeFineAllocation::whereHas('academicFeeHead', function ($q1) use ($feeheadlist) {
                                    return $q1->where('head_key', $feeheadlist->head_key);
                                })
                                ->with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                                ->where('id',$vvl->site_student_fee_fine_allocation_id)->first();
                            if($waiver_allocation_detail){
                                $tot_waiver_amount+=$vvl->amount;
                                if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                                    $waiver_type = AcademicAdmissionFeeType::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                                    $waiver_type = AcademicMonthName::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                                    $waiver_type = Examination::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->examination_name;

                                }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                                    $waiver_type = AcademicGeneralFeeType::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;
                                }

                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;
                                $waiver_allocation_details_arr[$waiver_srl]['amount']=$vvl->amount;

                                $waiver_srl++;
                            }


                        }

                    }
                }

                //===============fee details====================

                $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);
                $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->where('academic_fee_head_id', $request->checked_fee_head_id)->with('siteStudentFeeFineAllocation')->get();
                if (count($fee_generate_details) > 0) {
                    foreach ($fee_generate_details as $k => $v) {
                        $total_amount+= $v->amount;
                        $feeGenerateHistoryArr[$srl]['fee_item'] = AcademicFeeSubHead::where('id', $v->siteStudentFeeFineAllocation->academic_fee_sub_head_id)->first();
                        $feeGenerateHistoryArr[$srl]['amount'] = $v->amount;
                        $fee_allocation_detail = SiteStudentFeeFineAllocation::
                        with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                            ->where('id', $v->site_student_fee_fine_allocation_id)->first();

                        if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {

                            $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                            $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->name;


                        } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {

                            $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                            $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                        } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {

                            $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                            $feeGenerateHistoryArr[$srl]['fee_type_name'] = $fee_type->examination_name;
                        }

                        $srl++;
                    }
                }
            }

            $total_amount = number_format($total_amount);
            $tot_waiver_amount = number_format($tot_waiver_amount);

            return [$feeGenerateHistoryArr,$waiver_allocation_details_arr,$total_amount, $tot_waiver_amount];
        }







        return 'ok';

        $payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $request->student_histories_id)

            ->with('siteStudentFeeDemandSlipDetails')
            ->get();
//        return $payment_history;

//        $total_amount = 0;

        if (count($payment_history) > 0) {


            $paymentHistoryArr = Array();
            foreach ($payment_history as $key => $value) {
                $first[] = $value->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids;
                $fee_generate_id_splite = explode(',', $value->siteStudentFeeDemandSlipDetails->site_student_fee_generate_ids);
//                $first[] = $fee_generate_id_splite;
                $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->where('academic_fee_head_id', $request->checked_fee_head_id)->with('siteStudentFeeFineAllocation')->get();


                if (count($fee_generate_details) > 0) {

                    foreach ($fee_generate_details as $k => $v) {

                        $paymentHistoryArr[$key][$k]['fee_item'] = AcademicFeeSubHead::where('id', $v->siteStudentFeeFineAllocation->academic_fee_sub_head_id)->first();
                        $paymentHistoryArr[$key][$k]['amount'] = $v->amount;
//                        $createdDate = new DateTime($value->payment_date);
//                        $formatedDate = $createdDate->format('Y-m-d');
//
//                        $paymentHistoryArr[$key][$k]['taken_date'] = $formatedDate;
//                        $paymentHistoryArr[$key][$k]['taken_by'] = Employee::where('id', $value->created_by)->first();

//                        $total_amount+=$v->amount;

                        $fee_allocation_detail = SiteStudentFeeFineAllocation::
                        with(['academicFeeHead', 'academicFeeGroup', 'academicFeeSubHead'])
                            ->where('id', $v->site_student_fee_fine_allocation_id)->first();


                        if ($fee_allocation_detail->academicFeeHead->head_key == 'admission') {

                            $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key][$k]['fee_type_name'] = $fee_type->name;


                        } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'monthly') {
                            $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key][$k]['fee_type_name'] = $fee_type->name;

                        } elseif ($fee_allocation_detail->academicFeeHead->head_key == 'examination') {
                            $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$key][$k]['fee_type_name'] = $fee_type->examination_name;
                        }
                    }
                }
            }

            return $paymentHistoryArr;
        }
    }


    public function getSiteFeeHeadFeeTypeBaseFeeList(Request $request)
    {

//        return $request;
        $demand_slip_details = SiteStudentFeeDemandSlipDetails::where('student_history_id', $request->student_histories_id)->get();

//        $payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $request->student_histories_id)
//            ->where('status', 1)
//            ->with('siteStudentFeeDemandSlipDetails')
//            ->get();
        $paymentHistoryArr = Array();
        $srl = 0;
        $waiver_srl = 0;
        $total_amount = 0;
        $tot_waiver_amount = 0;
        $waiver_allocation_details_arr = Array();
        $feehead = $request->fee_head_name;

        if (count($demand_slip_details) > 0) {

            if (count($request->select_month_ids) > 0) {
                foreach ($demand_slip_details as $key => $value) {

                    //==================waiver details================

                    $waiver_generate_id_splite = explode(',', $value->site_student_fee_waiver_offer_history_ids);
                    $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)
                                                                            ->where('academic_fee_head_id', $request->checked_fee_head_id)
                                                                            ->whereIn('fee_head_type_id', $request->select_month_ids)
                                                                            ->get();

                    if(count($waiver_generate_list)>0){
                        foreach ($waiver_generate_list as $kk => $vvl){
                            $tot_waiver_amount+=$vvl->amount;
                            if($vvl->site_student_fee_fine_allocation_id){

                                $waiver_allocation_detail= SiteStudentFeeFineAllocation::whereHas('academicFeeHead', function ($q1) use ($feehead) {
                                    return $q1->where('head_key', $feehead);
                                })
                                    ->with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                                    ->where('id',$vvl->site_student_fee_fine_allocation_id)->first();

                                if ($waiver_allocation_detail->academicFeeHead->head_key == 'monthly'){
                                    $waiver_type = AcademicMonthName::where('id', $vvl->fee_head_type_id)->first();
                                    $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;
                                }
                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                                $waiver_allocation_details_arr[$waiver_srl]['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;
                                $waiver_allocation_details_arr[$waiver_srl]['amount']=$vvl->amount;

                                $waiver_srl++;

                            }

                        }
                    }

                    //======================fee details================

                    $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);

                    $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)->where('academic_fee_head_id', $request->checked_fee_head_id)->whereIn('fee_head_type_id', $request->select_month_ids)->with('siteStudentFeeFineAllocation')->get();

                    if (count($fee_generate_details) > 0) {

                        foreach ($fee_generate_details as $k => $v) {
                            $total_amount+=$v->amount;
                            $paymentHistoryArr[$srl]['fee_item'] = AcademicFeeSubHead::where('id', $v->siteStudentFeeFineAllocation->academic_fee_sub_head_id)->first();
                            $paymentHistoryArr[$srl]['amount'] = $v->amount;
                            $createdDate = new DateTime($value->payment_date);
                            $formatedDate = $createdDate->format('Y-m-d');

                            $paymentHistoryArr[$srl]['taken_date'] = $formatedDate;
                            $paymentHistoryArr[$srl]['taken_by'] = Employee::where('id', $value->created_by)->first();

                            $fee_type = AcademicMonthName::where('id', $v->fee_head_type_id)->first();
                            $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            $srl++;

                        }
                    }

                }

                return [$paymentHistoryArr, $waiver_allocation_details_arr, $total_amount, $tot_waiver_amount];


            } else if ($request->checked_admission_examination_general_id) {
//                return $request;

                foreach ($demand_slip_details as $key => $value) {

                    //==================waiver details================

                    $waiver_generate_id_splite = explode(',', $value->site_student_fee_waiver_offer_history_ids);
                    $waiver_generate_list = SiteStudentFeeWaiverOfferHistory::whereIn('id', $waiver_generate_id_splite)
                                                                            ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                                                                            ->where('academic_fee_head_id', $request->checked_fee_head_id)
                                                                            ->get();

                    if(count($waiver_generate_list)>0){
                        foreach ($waiver_generate_list as $kk => $vvl){
                            if($vvl->site_student_fee_fine_allocation_id){
                                $waiver_allocation_detail= SiteStudentFeeFineAllocation::whereHas('academicFeeHead', function ($q1) use ($feehead) {
                                    return $q1->where('head_key', $feehead);
                                })
                                    ->with(['academicFeeHead','academicFeeGroup','academicFeeSubHead'])
                                    ->where('id',$vvl->site_student_fee_fine_allocation_id)->first();
                                if($waiver_allocation_detail){

                                    $tot_waiver_amount+=$vvl->amount;

                                    if ($waiver_allocation_detail->academicFeeHead->head_key == 'admission'){
                                        $waiver_type = AcademicAdmissionFeeType::where('id', $vvl->fee_head_type_id)->first();
                                        $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;

                                    }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'examination'){
                                        $waiver_type = Examination::where('id', $vvl->fee_head_type_id)->first();
                                        $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->examination_name;

                                    }elseif ($waiver_allocation_detail->academicFeeHead->head_key == 'general'){
                                        $waiver_type = AcademicGeneralFeeType::where('id', $vvl->fee_head_type_id)->first();
                                        $waiver_allocation_details_arr[$waiver_srl]['fee_type_name'] = $waiver_type->name;
                                    }

                                    $waiver_allocation_details_arr[$waiver_srl]['academic_fee_head']=$waiver_allocation_detail->academicFeeHead;
                                    $waiver_allocation_details_arr[$waiver_srl]['academic_fee_sub_head']=$waiver_allocation_detail->academicFeeSubHead;
                                    $waiver_allocation_details_arr[$waiver_srl]['amount']=$vvl->amount;

                                    $waiver_srl++;
                                }

                            }

                        }
                    }

                    //==================fee details===================

                    $fee_generate_id_splite = explode(',', $value->site_student_fee_generate_ids);
                    $fee_generate_details = SiteStudentFeeGenerate::whereIn('id', $fee_generate_id_splite)
                                                                    ->where('fee_head_type_id', $request->checked_admission_examination_general_id)
                                                                    ->where('academic_fee_head_id', $request->checked_fee_head_id)
                                                                    ->with('siteStudentFeeFineAllocation')->get();
                    if (count($fee_generate_details) > 0) {

                        foreach ($fee_generate_details as $k => $v) {

                            $total_amount+=$v->amount;

                            $paymentHistoryArr[$srl]['fee_item'] = AcademicFeeSubHead::where('id', $v->siteStudentFeeFineAllocation->academic_fee_sub_head_id)->first();
                            $paymentHistoryArr[$srl]['amount'] = $v->amount;
                            $createdDate = new DateTime($value->payment_date);
                            $formatedDate = $createdDate->format('Y-m-d');
                            $paymentHistoryArr[$srl]['taken_date'] = $formatedDate;
                            $paymentHistoryArr[$srl]['taken_by'] = Employee::where('id', $value->created_by)->first();

                            if ($request->fee_head_name == 'admission') {
                                $fee_type = AcademicAdmissionFeeType::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->name;

                            } elseif ($request->fee_head_name == 'examination') {

                                $fee_type = Examination::where('id', $v->fee_head_type_id)->first();
                                $paymentHistoryArr[$srl]['fee_type_name'] = $fee_type->examination_name;
                            }

                            $srl++;

                        }
                        return [$paymentHistoryArr, $waiver_allocation_details_arr, $total_amount, $tot_waiver_amount];
                    } else {
                        throw new Error('Sorry! data not found!');
                    }
                }

            } else {

//                return Response::json(['message' => 'payment no given at yet!'], 200);
                throw new Error('please select item');
            }
        } else {
            throw new Error('student not found');
        }
    }

    public function getSiteSingleStudentFeeSummary(Request $request)
    {
//        return $request;
        $academic_year_id = $request->academic_year_id;

        if ($request->user_name) {
            $userList = Student::where('username', $request->user_name)->select('id')->first();
            if ($userList) {
                if($academic_year_id){
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('academic_year_id',$academic_year_id)
                        ->orderBy('id','desc')
                        ->first();

                }else{
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section'])
                        ->where('user_id', $userList->id)
                        ->where('status', 1)
                        ->first();
                }

            } else {
                throw new Error('Sorry! Student not found');
            }

            $payment_slip_details = SiteStudentFeePaymentHistory::where('student_history_id', $studentHistoryList->id)->with('user')->get();
            $dataArr = [];
            $total_paid_amount = 0;
            if(count($payment_slip_details)>0){
                foreach ($payment_slip_details as $key => $value){
                    $dataArr[$key]['id'] = $value->id;
                    $dataArr[$key]['voucher_no'] = $value->voucher_no;
                    $dataArr[$key]['payment_date'] = $value->payment_date;
                    $dataArr[$key]['created_by'] = $value->user->full_name ?? "";
                    $dataArr[$key]['paid_amount'] = $value->paid_amount;
                    $dataArr[$key]['paid_by'] = $value->paid_by;

                    $total_paid_amount+=$value->paid_amount;
                }
            }else{
                throw new Error('Sorry! payment not taken at yet');
            }
            $stdDetailsArray['std_id'] = $studentHistoryList->id;
            $stdDetailsArray['std_name'] = $studentHistoryList->student ? $studentHistoryList->student->full_name : "";
            $stdDetailsArray['department_name'] = $studentHistoryList->department ? $studentHistoryList->department->class_name : "";
            $stdDetailsArray['class_name'] = $studentHistoryList->stClass->class_name;
            $stdDetailsArray['group_name'] = $studentHistoryList->accGroup ? $studentHistoryList->accGroup->group_name : "";
            $stdDetailsArray['section_name'] = $studentHistoryList->section ? $studentHistoryList->section->section_name : "";

            return [$dataArr, $stdDetailsArray, $total_paid_amount];

        }else{
            throw new Error('Sorry! Please write student ID');
        }
    }


    public function getSiteFeeHeadClassBaseFeeList(Request $request)
    {

        $data = $request->all();

        $student_hstory_list = StudentHistory::where('academic_class_id', $request->academic_class_id)
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->with('student')
//            ->where('status', true)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->orderBy('academic_class_id', 'ASC')
            ->orderBy('academic_class_group_id', 'ASC')
            ->orderBy('academic_section_id', 'ASC')
            ->orderBy('student_roll_number', 'ASC')
            ->get();
//        return $student_hstory_list;

        if (count($student_hstory_list) > 0) {
            $gross_total_paid_amount = 0;
            $gross_total_due_amount = 0;
            $gross_total_generate_amount = 0;
            $gross_total_payable_amount = 0;
            $gross_waiver_amount = 0;
            $gross_fee_fine = 0;

            foreach ($student_hstory_list as $key => $value) {
                if ($request->start_date && $request->end_date) {
                    $payment_history_list = SiteStudentFeePaymentHistory::where('student_history_id', $value->id)
                        ->whereBetween('payment_date', [$request->start_date, $request->end_date])
                        ->with('siteStudentFeeDemandSlipDetails')->get();
                } else {
                    $payment_history_list = SiteStudentFeePaymentHistory::where('student_history_id', $value->id)->with('siteStudentFeeDemandSlipDetails')->get();
                }

                $data[$key] = $payment_history_list;
                $total_paid_amount = 0;
//                $total_waiver = 0;
//                $total_generate_amount = 0;



                $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id', $value->id)->get();
//                    return $demand_slip;

                $generated_amount = 0;
                $waiver_amount = 0;
                $paid_amount = 0;

                if(count($demand_slip)){

                    foreach ($demand_slip as $kk => $vl){
                        $generated_amount  += $vl->fee_amount;
                        $waiver_amount += $vl->waiver_amount +  $vl->special_waiver_amount;


                    }

                    $dataListArr[$key]['total_generate_amount'] = $generated_amount;
                    $dataListArr[$key]['total_waiver_amount'] = $waiver_amount;


                }
                $dataListArr[$key]['total_generate_amount'] = $generated_amount;
                $dataListArr[$key]['total_waiver_amount'] = $waiver_amount;

                $user_details = Student::where('id', $value->user_id)->first();

//                return $user_details;

                $dataListArr[$key]['std_name'] = $user_details->full_name??null;
                $dataListArr[$key]['reg_no'] = $user_details->username??null;


                if (count($payment_history_list) > 0) {


//                    $total_payable_amount = 0;
                    foreach ($payment_history_list as $k => $v) {

                        $total_paid_amount += $v->paid_amount;
                    }

                    $due = $payment_history_list->pluck('due_amount')->last();
                    $dataListArr[$key]['due'] = $due;

//                    $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id', $value->id)->where('status', 1)->first();
//
//                    if($demand_slip){
//
//                    }


                } else {



                    $dataListArr[$key]['total_paid_amount'] = 0;

//                    return $demand_slip;
//                    if ($demand_slip) {
//                        $dataListArr[$key]['due'] = $demand_slip->total_amount;
//                        $dataListArr[$key]['total_waiver_amount'] = $waiver_amount;
//                        $dataListArr[$key]['total_generate_amount'] = $generated_amount;
//                        $dataListArr[$key]['total_paid_amount'] = 0;
//
//                    } else {
//
//                        $dataListArr[$key]['due'] = 0;
//                        $dataListArr[$key]['total_waiver_amount'] = $total_waiver;
//                        $dataListArr[$key]['total_generate_amount'] = $total_generate_amount;
//                        $dataListArr[$key]['total_paid_amount'] = $total_paid_amount;
//
//                    }


                }
                $fee_fine_details = SiteStudentFeeFine::where('student_history_id', $value->id)->get();
                $fee_fine=0;
                if (count($fee_fine_details)){
                    foreach ($fee_fine_details as $ke => $vv){
                        $fee_fine+= $vv->fine_amount;
                    }
                }
//                return $dataListArr;
                $dataListArr[$key]['total_paid_amount'] = $total_paid_amount;
                $dataListArr[$key]['fee_fine'] = $fee_fine;
                $dataListArr[$key]['total_payable_amount'] = ($dataListArr[$key]['total_generate_amount'] + $fee_fine) - $dataListArr[$key]['total_waiver_amount'];
                $dataListArr[$key]['due'] = $dataListArr[$key]['total_payable_amount'] - $total_paid_amount;


//                return $dataListArr;

                $gross_total_paid_amount += $dataListArr[$key]['total_paid_amount']??0;
                $gross_total_due_amount += $dataListArr[$key]['due'];
                $gross_total_generate_amount += $dataListArr[$key]['total_generate_amount'];
                $gross_total_payable_amount += $dataListArr[$key]['total_payable_amount'];

                $gross_waiver_amount += $dataListArr[$key]['total_waiver_amount']??0;
                $gross_fee_fine += $dataListArr[$key]['fee_fine'];

            }
//            return $data;

            return [$dataListArr, $gross_total_paid_amount, $gross_total_due_amount, $gross_total_generate_amount , $gross_waiver_amount,$gross_fee_fine,$gross_total_payable_amount];

        }
        throw new Error('payment not found!');


    }

    public function getSiteGeneralFeeList(Request $request)
    {
        if (count($request->academic_class_ids) > 0) {

            $gross_total_generate_amount = 0;
            $gross_total_paid_amount = 0;
            $gross_total_waiver_amount = 0;
            $gross_total_fine_amount = 0;
            $gross_total_due_amount = 0;

            foreach ($request->academic_class_ids as $key => $value) {
                $total_generate_amount = 0;
                $total_paid_amount = 0;
                $total_waiver_amount = 0;
                $total_due_amount = 0;
                $total_fine_amount = 0;

                $student_class_base_history_list = StudentHistory::where('academic_class_id', $value)
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
//                    ->where('status', 1)
                    ->with('stClass')
                    ->get();


                if (count($student_class_base_history_list) > 0) {

                    foreach ($student_class_base_history_list as $ke => $va) {

                        $std_generate_amount = 0;
                        $std_paid_amount = 0;
                        $std_waiver_amount = 0;
                        if ($request->start_date && $request->end_date) {
                            $std_payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $va->id)
                                ->whereBetween('payment_date', [$request->start_date, $request->end_date])
                                ->with('siteStudentFeeDemandSlipDetails')->get();
                        } else {
                            $std_payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $va->id)->with('siteStudentFeeDemandSlipDetails')->get();
                        }


                        if (count($std_payment_history) > 0) {
                            foreach ($std_payment_history as $kk => $vv) {

                                $std_generate_amount += $vv->siteStudentFeeDemandSlipDetails ? $vv->siteStudentFeeDemandSlipDetails->fee_amount : 0;
                                $std_paid_amount += $vv->paid_amount;
                                $std_waiver_amount += $vv->siteStudentFeeDemandSlipDetails ? $vv->siteStudentFeeDemandSlipDetails->waiver_amount : 0;

                            }

                            $student_demand_slip_details = SiteStudentFeeDemandSlipDetails::where('student_history_id', $va->id)->where('status', 1)->first();
                            if ($student_demand_slip_details) {
                                $last_due_amount = $student_demand_slip_details->total_amount;
                            } else {
                                $last_due = $std_payment_history->last();
                                $last_due_amount = $last_due->due_amount;
                            }

                            $total_generate_amount += $std_generate_amount;
                            $total_paid_amount += $std_paid_amount;
                            $total_waiver_amount += $std_waiver_amount;
                            $total_due_amount += $last_due_amount;

                        }else{


                            $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id',  $va->id)->where('status', 1)->first();

                            if ($demand_slip) {
                                $total_due_amount+= $demand_slip->total_amount;
                                $total_waiver_amount+= $demand_slip->waiver_amount;
                                $total_generate_amount+= $demand_slip->fee_amount;

                            } else {

                            }
                        }

                        $fee_fine_details = SiteStudentFeeFine::where('student_history_id', $va->id)->get();
                        $fee_fine = 0;
                        if (count($fee_fine_details)){
                            foreach ($fee_fine_details as $kkk => $vvv){
                                $fee_fine+= $vvv->fine_amount;
                            }
                        }

                        $total_fine_amount+= $fee_fine;

                    }
                }
                $total_payable_amount = ($total_generate_amount + $total_fine_amount) - $total_waiver_amount;

                $final_data[$key]['total_generate_amount'] = $total_generate_amount;
                $final_data[$key]['total_paid_amount'] = $total_paid_amount;
                $final_data[$key]['total_waiver_amount'] = $total_waiver_amount;
                $final_data[$key]['total_fine_amount'] = $total_fine_amount;
                $final_data[$key]['total_due_amount'] = $total_due_amount;
                $final_data[$key]['total_payable_amount'] = $total_payable_amount;

                $class_name = AcademicClass::where('id', $value)->first();
                $final_data[$key]['class_name'] = $class_name->class_name;

                $gross_total_generate_amount += $final_data[$key]['total_generate_amount'];
                $gross_total_paid_amount += $final_data[$key]['total_paid_amount'];
                $gross_total_waiver_amount += $final_data[$key]['total_waiver_amount'];
                $gross_total_fine_amount += $final_data[$key]['total_fine_amount'];
                $gross_total_due_amount += $final_data[$key]['total_due_amount'];

            }
            $gross_total_payable_amount = ($gross_total_generate_amount + $gross_total_fine_amount) - $gross_total_waiver_amount;

            $gross_report['gross_total_generate_amount'] = $gross_total_generate_amount;
            $gross_report['gross_total_paid_amount'] = $gross_total_paid_amount;
            $gross_report['gross_total_waiver_amount'] = $gross_total_waiver_amount;
            $gross_report['gross_total_fine_amount'] = $gross_total_fine_amount;
            $gross_report['gross_total_due_amount'] = $gross_total_due_amount;
            $gross_report['gross_total_payable_amount'] = $gross_total_payable_amount;



            return [$final_data, $gross_report];

        } else if (count($request->academic_class_list) > 0) {

            $gross_total_generate_amount = 0;
            $gross_total_payable_amount = 0;
            $gross_total_paid_amount = 0;
            $gross_total_waiver_amount = 0;
            $gross_total_fine_amount = 0;
            $gross_total_due_amount = 0;

            foreach ($request->academic_class_list as $key => $value) {

                $total_generate_amount = 0;
                $total_paid_amount = 0;
                $total_waiver_amount = 0;
                $total_fine_amount = 0;
                $total_due_amount = 0;

                $student_class_base_history_list = StudentHistory::where('academic_class_id', $value['id'])
                    ->where('academic_version_id', $request->academic_version_id)
                    ->where('academic_year_id', $request->academic_year_id)
                    ->where('academic_shift_id', $request->academic_shift_id)
//                    ->where('status', 1)
                    ->with('stClass')
                    ->get();
//                return $student_class_base_history_list->count();

                if (count($student_class_base_history_list) > 0) {


                    foreach ($student_class_base_history_list as $ke => $va) {

                        if ($request->start_date && $request->end_date) {
                            $std_payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $va->id)
                                ->whereBetween('payment_date', [$request->start_date, $request->end_date])
                                ->with('siteStudentFeeDemandSlipDetails')->get();
                        } else {
                            $std_payment_history = SiteStudentFeePaymentHistory::where('student_history_id', $va->id)->with('siteStudentFeeDemandSlipDetails')->get();
                        }



                        if (count($std_payment_history) > 0) {
                            foreach ($std_payment_history as $kk => $vv) {
                                $total_paid_amount += $vv->paid_amount;
                            }
                        }

                        $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id',  $va->id)->get();

                        if (count($demand_slip)>0) {
                            foreach ($demand_slip as $kkk => $vvv){
//                                $total_due_amount+= $demand_slip->total_amount;
                                $total_waiver_amount+= $vvv->waiver_amount + $vvv->special_waiver_amount;
                                $total_generate_amount+= $vvv->fee_amount;
                            }


                        }


//                        if (count($std_payment_history) > 0) {
//                            foreach ($std_payment_history as $kk => $vv) {
////                                return $vv->siteStudentFeeDemandSlipDetails;
//
//                                $total_generate_amount += $vv->siteStudentFeeDemandSlipDetails ? $vv->siteStudentFeeDemandSlipDetails->fee_amount : 0;
//                                $total_paid_amount += $vv->paid_amount;
//                                $total_waiver_amount += $vv->siteStudentFeeDemandSlipDetails ? $vv->siteStudentFeeDemandSlipDetails->waiver_amount : 0;
//
//                            }
//                            $student_demand_slip_details = SiteStudentFeeDemandSlipDetails::where('student_history_id', $va->id)->where('status', 1)->first();
//                            if ($student_demand_slip_details) {
//                                $count+=1;
//                                $last_due_amount = $student_demand_slip_details->total_amount;
//                            } else {
//                                $count+=1;
//                                $last_due = $std_payment_history->last();
//                                $last_due_amount = $last_due->due_amount;
//                            }
//
//
//                            $total_due_amount += $last_due_amount;
//
//
//
//                        }else{
//
//
//                            $demand_slip = SiteStudentFeeDemandSlipDetails::where('student_history_id',  $va->id)->where('status', 1)->first();
//
//                            if ($demand_slip) {
//                                $count+=1;
//                                $total_due_amount+= $demand_slip->total_amount;
//                                $total_waiver_amount+= $demand_slip->waiver_amount;
//                                $total_generate_amount+= $demand_slip->fee_amount;
//
//                            } else {
//
//                            }
//                        }

                        $fee_fine = 0;
                        $fee_fine_details = SiteStudentFeeFine::where('student_history_id', $va->id)->get();
                        if (count($fee_fine_details)){
                            foreach ($fee_fine_details as $kkk => $vvv){
                                $fee_fine+= $vvv->fine_amount;
                            }
                        }
                        $total_fine_amount+= $fee_fine;

                    }
                }
                $total_payable_amount = ($total_generate_amount + $total_fine_amount) - $total_waiver_amount;

                $final_data[$key]['total_generate_amount'] = $total_generate_amount;
                $final_data[$key]['total_payable_amount'] = $total_payable_amount;
                $final_data[$key]['total_paid_amount'] = $total_paid_amount;
                $final_data[$key]['total_waiver_amount'] = $total_waiver_amount;
                $final_data[$key]['total_fine_amount'] = $total_fine_amount;
                $final_data[$key]['total_due_amount'] = $total_payable_amount - $total_paid_amount;
                $class_name = AcademicClass::where('id', $value['id'])->first();
                $final_data[$key]['class_name'] = $class_name->class_name;



                $gross_total_generate_amount += $final_data[$key]['total_generate_amount'];
                $gross_total_payable_amount += $final_data[$key]['total_payable_amount'];
                $gross_total_paid_amount += $final_data[$key]['total_paid_amount'];
                $gross_total_waiver_amount += $final_data[$key]['total_waiver_amount'];
                $gross_total_fine_amount += $final_data[$key]['total_fine_amount'];
                $gross_total_due_amount += $final_data[$key]['total_due_amount'];

            }
            $gross_report['gross_total_generate_amount'] = $gross_total_generate_amount;
            $gross_report['gross_total_payable_amount'] = $gross_total_payable_amount;
            $gross_report['gross_total_paid_amount'] = $gross_total_paid_amount;
            $gross_report['gross_total_waiver_amount'] = $gross_total_waiver_amount;
            $gross_report['gross_total_fine_amount'] = $gross_total_fine_amount;
            $gross_report['gross_total_due_amount'] = $gross_total_due_amount;

            return [$final_data, $gross_report];


        } else {
            throw new Error('student not found');
        }


    }

    public function pdfStudentWisePaymentReport(Request $request)
    {


        \Log::info($request);
        return $request;

        $pdf = PDF::loadView('default.admin.site.student-fee.report.student-wise-payment-pdf', compact('data'));
        return $pdf->stream(time() . '-student-payment.pdf');
    }

    public function showIndividualStudentPaymentSummaryReportPdf($user_name, $year_id = null)
    {
//        return [$user_name, $year_id];
        $academic_year_id = $year_id;

        if ($user_name) {
            $userList = Student::where('username', $user_name)->select('id')->first();
            if ($userList) {
//                $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
//                                                        ->where('user_id', $userList->id)->where('status', 1)->first();

                if($academic_year_id){
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
                        ->where('user_id', $userList->id)
                        ->where('academic_year_id',$academic_year_id)
                        ->orderBy('id','desc')
                        ->first();

                }else{
                    $studentHistoryList = StudentHistory::with(['student', 'stClass', 'accGroup', 'section', 'department'])
                        ->where('user_id', $userList->id)
                        ->where('status', 1)
                        ->first();
                }

            } else {
                throw new Error('Sorry! Student not found');
            }

            $payment_slip_details = SiteStudentFeePaymentHistory::where('student_history_id', $studentHistoryList->id)->with('user')->get();
            $dataArr = [];
            $total_paid_amount = 0;
            if(count($payment_slip_details)>0){
                foreach ($payment_slip_details as $key => $value){
                    $dataArr[$key]['id'] = $value->id;
                    $dataArr[$key]['voucher_no'] = $value->voucher_no;
                    $dataArr[$key]['payment_date'] = $value->payment_date;
                    $dataArr[$key]['created_by'] = $value->user->full_name ?? "";
                    $dataArr[$key]['paid_amount'] = $value->paid_amount;

                    $total_paid_amount+=$value->paid_amount;
                }
            }else{
                throw new Error('Sorry! payment not taken at yet');
            }
            $stdDetailsArray['std_id'] = $studentHistoryList->id;
            $stdDetailsArray['std_name'] = $studentHistoryList->student ? $studentHistoryList->student->full_name : "";
            $stdDetailsArray['department_name'] = $studentHistoryList->department ? $studentHistoryList->department->class_name : "";
            $stdDetailsArray['class_name'] = $studentHistoryList->stClass->class_name;
            $stdDetailsArray['group_name'] = $studentHistoryList->accGroup ? $studentHistoryList->accGroup->group_name : "";
            $stdDetailsArray['section_name'] = $studentHistoryList->section ? $studentHistoryList->section->section_name : "";

//            return [$dataArr, $stdDetailsArray, $total_paid_amount];
            $title_view = 'Student Payment Summary';
            $report_tittle = '<b>Student Payment Summary Report</b><br>';
            $report_tittle2  = '';



            $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-summary-report-pdf', compact('title_view','report_tittle','report_tittle2','dataArr','stdDetailsArray','total_paid_amount'));
            return $pdf->stream(time() . '-student-payment-summary.pdf');

        }else{
            throw new Error('Sorry! Please write student ID');
        }


    }

    public function createClassBasePaymentReportPdf(Request $request)
    {
//        return $request;
        $site_id = (int)session()->get('SITE_ID');
        $site = SiteInfo::where('id', $site_id)->first();
//        return $site_id;

        $class_details = AcademicClass::where('id', $request->academic_class_id)->select('class_name')->first();
        $class_group_details = AcademicClassGroup::where('id', $request->academic_class_group_id)->select('group_name')->first();
        $class_section_details = AcademicSection::where('id', $request->academic_section_id)->select('section_name')->first();
        $class_shift_details = AcademicShift::where('id', $request->academic_shift_id)->first();
        $from_date = $request->start_date;
        $to_date = $request->end_date;

        $title_view = 'Class Wise report';

        $all_student_total_payment_list = $request->allStudentTotalPaymentHistoryList;

        $all_std_total_paid_amount = $request->allStudentTotalPaidAmount;
        $all_student_total_paid_amount = number_format($all_std_total_paid_amount);

        $all_std_total_due_amount = $request->allStudentTotalDueAmount;
        $all_student_total_due_amount = number_format($all_std_total_due_amount);

        $all_std_total_generate_amount = $request->allStudentTotalGenerateAmount;
        $all_std_total_generate_amount = number_format($all_std_total_generate_amount);

        $all_std_total_payable_amount = $request->allStudentTotalPayableAmount;
        $all_student_total_payable_amount = number_format($all_std_total_payable_amount);

        $all_std_total_waiver_amount = $request->allStudentTotalWaiverAmount;
        $all_student_total_waiver_amount = number_format($all_std_total_waiver_amount);

        $all_std_total_fee_fine_amount = $request->allStudentTotalFeeFineAmount;
        $all_std_total_fee_fine_amount = number_format($all_std_total_fee_fine_amount);

        $report_tittle = '<b>Class Wise Payment Report</b><br>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-class-wise-report-pdf', compact('title_view','class_details', 'class_group_details', 'class_section_details',
            'class_shift_details', 'report_tittle','report_tittle2', 'from_date', 'to_date', 'all_student_total_payment_list','all_student_total_paid_amount',
            'all_student_total_due_amount','all_student_total_payable_amount','all_student_total_waiver_amount','all_std_total_fee_fine_amount','all_std_total_generate_amount','site'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);
//        return $class_shift_details->shift_name;

    }

    public function classBasePaymentPdfShow($data)
    {
//        return $data;

        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }


            if (!file_exists(storage_path('pdf/' . $data))) {

                return "The file existed only for 1 day and deleted today!";

            }

            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function createGeneralPaymentReportPdf(Request $request)
    {
//        return $request;

        $site_id = (int)session()->get('SITE_ID');
        $site = SiteInfo::where('id', $site_id)->first();

        $class_shift_details = AcademicShift::where('id', $request->academic_shift_id)->first();
        $from_date = $request->start_date;
        $to_date = $request->end_date;

        $title_view = 'General report';

        $all_class_total_payment_list = $request->allClassTotalPaymentList;
        $total_paid_amnt = $request->totalPaidAmount;
        $total_paid_amount = number_format($total_paid_amnt);

        $total_due_amnt = $request->totalDueAmount;
        $total_due_amount = number_format($total_due_amnt);

        $total_generate_amnt = $request->totalGenerateAmount;
        $total_generate_amount = number_format($total_generate_amnt);

        $total_payable_amnt = $request->totalPayableAmount;
        $total_payable_amount = number_format($total_payable_amnt);

        $total_waiver_amnt = $request->totalWaiverAmount;
        $total_waiver_amount = number_format($total_waiver_amnt);

        $total_fee_fine_amnt = $request->totalFeeFine;
        $total_fee_fine_amnt = number_format($total_fee_fine_amnt);

        $print_date = Carbon::today();
        $print_date = $print_date->toDateString();
        $report_tittle = '<b>General Fee Report</b>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.general-payment-report-pdf', compact('title_view',
            'report_tittle2','report_tittle','print_date','class_shift_details', 'from_date', 'to_date', 'all_class_total_payment_list','total_paid_amount',
            'total_due_amount','total_payable_amount','total_waiver_amount','total_fee_fine_amnt','total_generate_amount','site'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();


        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        //  return response()->download($path.'/'.$time.'.pdf');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);

    }

    public function showGeneralReportPdf($data)
    {
//        return $data;
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }


            if (!file_exists(storage_path('pdf/' . $data))) {

                return "The file existed only for 1 day and deleted today!";

            }


            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    public function createIndividualPaymentReportPdf(Request $request)
    {
//return $request;
        $title_view = 'Individual report';
        $std_fee_list =  $request->single_student_fee_list;
        $std_fee_waiver_list =  $request->waiver_allocation_details;

        $total_fee_amount = $request->total_fee_amount;
        $total_waiver_amount = number_format($request->total_waiver_amount);

//dd($std_fee_waiver_list, $total_fee_amount, $total_waiver_amount);
        $fee_head = AcademicFeeHead::where('id', $request->checked_fee_head_id)->first();

        $std_details = $request->student_details;

        $report_tittle = '<b>Student Wise Payment Report</b><br>';
        $report_tittle2  = '';

        $pdf = PDF::loadView('default.admin.site.student-fee.report.payment-student-wise-report-pdf',
            compact('title_view','report_tittle','report_tittle2','std_fee_list',
                'fee_head','std_details','std_fee_waiver_list','total_fee_amount','total_waiver_amount'));

        $path = storage_path() . '/pdf';

        $time = Auth::user()->id . '-' . Carbon::now()->unix();

        $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');

        $name = $time . '.pdf';

        return Response::json(['message' => $name], 200);

    }

    public function showIndividualPaymentReportPdf($data)
    {
//        return $data;
        try {

            $user_id = Auth::user()->id;

            $name_split = preg_split("/\-/", $data);

            if ($name_split[0] != $user_id) {
                return 'You are unauthorized!';
            }


            if (!file_exists(storage_path('pdf/' . $data))) {

                return "The file existed only for 1 day and deleted today!";

            }


            return response()->file(storage_path('pdf/' . $data));

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
